//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: example of external interrupt
//******************************************
//******************************************
//Stack Pointer	=	0x23f (If use mq6822_32PinPackage_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 

void main()
{

	WDCDR.byte = 0x4e;	//clear WDT


	P9CR.bit.b0 = 1;		//set P90 output mode

    P7CR.bit.b7=0;			//set P77(INT4) input mode
	P7PU.bit.b7=1;			//set P77 pull high


	__asm("DI");			//mask all interrupt
	POFFCR3.bit.b4=1;		//enable clock suppy to INT4 and active external interrupt detect
	EINTCR4.byte=0x04;		//Set INT4 falling edge detect
	EIRE.bit.b4=1;			//enable INT4 signal to CPU
	__asm("EI");			//unmask all interrupt   
	
	while(1)
	{
		WDCDR.byte = 0x4e;	//clear WDT
	}          
       	
}

